'****************************************************************
'*  Name    : onboard.BAS                                       *
'*  Author  : R W Burrows G8BYI                                 *
'*  Notice  : Copyright (c) 2011 [select VIEW...EDITOR OPTIONS] *
'*          : All Rights Reserved                               *
'*  Date    : 17/05/2011                                        *
'*  Version : 1.0         for g8byi/gb3ut use                   *
'*  Notes   :  Program to control a adf4360-7 vco/pll board to  *
'*            generate 2 frequencies for Digi-Lite 70cm datv tx.*
'*            Uses existing pic thats on pll/vco pcb.           *
'****************************************************************
Device 12F629 'Note disable lowvoltage programming flag

Config pwrte_on, wdt_off ,MCLRE_OFF ,INTRC_OSC_NOCLKOUT


Dim RCL As DWord   'R-counter latch 24bit word 
Dim NCL As DWord   'N-counter latch  24bit word 
Dim CL  As DWord   'Device Control latch 24bit word 
Dim a As  RCL.BYTE2
Dim b As  RCL.BYTE1
Dim c As  RCL.LowByte
Dim d As  CL.BYTE2
Dim e As  CL.BYTE1
Dim f As  CL.LowByte
Dim g As  NCL. BYTE2
Dim h As  NCL. BYTE1
Dim i As  NCL. LowByte
Dim freq As Bit
   Output GPIO.1 'use pin6 GP1 12f629 
   Output GPIO.0 'use pin7 GP0 12f629 
   Output GPIO.4 'use pin3 GP4 12f629   
   Input GPIO.2 'use pin5 as GP5 freq change link/switch   high or low state
   Symbol clk = GPIO.1 ' ADF4350-5 Clock pin 17  connects  to pin6 pad old pic
   Symbol dta = GPIO.0 ' ADF4350-5 Dataout pin 18 connects to pin7 pad old pic
   Symbol LE  = GPIO.4 ' ADF4350-5 SPI LE pin 19  connects to pin3 pad old pic
   Symbol frechn= GPIO.2   ' ADF4350-5 connects to pin5 pad old pic
 'Use pin 5 ( gpio.2)of 12f629 with 1pole-2way switch connected to
 ' this port or use a link to ground. This selects one of the 2 frequencies.
     
 Low GPIO.0:Low GPIO.1:Low GPIO.4   'set data lines low         
 
  NCL= $8812 :  'fvco=436MHz  initial power up freq
  DelayMS 100
 start:
 GoSub setreg
 GoSub load
 GoSub loop
  End
 
setreg: 'Set register values
   
'R divider latch
   RCL= $3000C9  : '10mhz ref xtal
'Control latch
   CL= $4FE904    
' N divider latch for frequency selection
    freq = GPIO.2  'change code for pin state 1=436MHz 0=437MHz
   If freq=1 Then  GoSub freq1  
   If freq=0 Then  GoSub freq2
   
   Return
    
 loop: 
    If freq<> GPIO.2 Then GoTo start
    GoTo loop   
   Return
   
 freq1:
     NCL= $8812 :  GoSub load 'fvco=436MHz 
  Return
 
 freq2:
     NCL= $8826 : GoSub load 'fvco=437MHz 
  Return  
 
  '***change here
 load:
  'sends commands to pll
 DelayMS 100
 Low LE
  SHOut dta,clk,msbfirst_l,[a,b,c] '  Set ref divisor
  High LE:DelayUS 1: Low LE         
      DelayMS 50
  SHOut dta,clk,msbfirst_l,[d,e,f] '  initiate control latch
  High LE:DelayUS 1:Low LE            
      DelayMS 200
  SHOut dta,clk,msbfirst_l,[g,h,i] 'Set N divisor 
  High LE:DelayUS 1:Low LE     
      DelayMS 10
   Input GPIO.2           
   Low GPIO.0:Low GPIO.1:Low GPIO.4     
     
 Return       
 'Programming notes 
  'ensure  R latch is loaded first then Control latch then N latch.
  'DWORD usage - lowbytes=1st 8bits byte1=2nd 8bits, byte2=3rd 8bits
  '
 'Freq as defined
 'frequency/register hex  settings  switched by high/low set on pin 5 (GPIO.2)
 '   Fvco,   CL,    NCL,   RCL
 '   436   $4FE904  $8812  $3000C9
 '   437   $4FE904  $8826  $3000C9
            
            
            
 '+++Other chip Parameters that are set+++
 
' PFD Freq 200Khz
' Ref Freq 10MHz
' RF Prescaler 16/17
' Internal /2 not selected
' Output /2 not selected
' CP Gain=0 Current setting 2.5mA
' RF PD Polarity Positive
' Charge pump active
' Counter Reset Disabled
' Lock detect Precision=3
' Band Select Clock Divider Value=8
' O/P power -6dbm
' Core Power 10mA
' Mute till lock enabled
End




